<?php

$data = MetaHandler::get_data();
$siteConfig = json_decode(file_get_contents(INC . "siteData/site-data.json"), true);
 ?>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="format-detection" content="telephone=no">
<meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=5">

<?php

if ( !isset($share_image) ) $share_image = "https://lagencepigment.com/assets/img/share-image.png";
if ( !isset($share_title) ) $share_title = "L'Agence Pigment";

if ( isset($data['noindex']) && $data['noindex'] === true ) echo '<meta name="robots" content="noindex, follow">';

?>

<meta property="og:url" content="<?= $data['canonical'] ?>">
<meta property="og:type" content="website">
<meta property="og:title" content="<?= $share_title ?>">
<meta property="og:image" content="<?= $share_image ?>">
<meta property="og:description" content="<?= $data['description'] ?>">
<meta property="og:site_name" content="Skål">

<meta name="twitter:card" content="summary">
<meta name="twitter:url" content="<?= $data['canonical'] ?>">
<meta name="twitter:title" content="<?= $share_title ?>">
<meta name="twitter:description" content="<?= $data['description'] ?>">
<meta name="twitter:image" content="<?= $share_image ?>">

<meta name="theme-color" content="#fff">


<meta name="description" content="<?= $data['description'] ?>">
<meta name="author" content="Sam Phlix">

<link rel="stylesheet" href="assets/css/style.css?rd=1234">
<link rel="shortcut icon" href="/assets/img/favicon/favicon.ico">
<link rel="apple-touch-icon" sizes="180x180" href="/assets/img/favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/img/favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/assets/img/favicon/favicon-16x16.png">
<link rel="manifest" href="/assets/img/favicon/site.webmanifest">
<link rel="mask-icon" href="/assets/img/favicon/safari-pinned-tab.svg" color="#5bbad5">
<meta name="msapplication-TileColor" content="#da532c">
<meta name="msapplication-config" content="/assets/img/favicon/browserconfig.xml">
<meta name="theme-color" content="#ffffff">

<link rel="canonical" href="<?= $data['canonical'] ?>">

<?php 
    foreach ($siteConfig["languages"] as $language): 
        if ($language != LANG):
?>

    <link rel="alternate" href="<?= rtrim(SITE_URL, '/') . "/" . $language ?>" hreflang="<?= $language ?>">

<?php 
        endif;
    endforeach; 
?>