<?php

//==============================================================================
//                               Load files
//==============================================================================


// LOCAL CONFIG

// 01 - Location des uploads
define( 'UPLOADS_URL', '/assets/' );

// 02 - Url du site
define( 'SITE_URL', 'https://lap.ama.je/' );


// INI SET

ini_set('session.cookie_httponly', 1); // Evite la récupération de l'id de session via javascript
ini_set('session.use_strict_mode', 1); // Utilisation du stric mode, n'accepte pas d'id fourni par l'utilisateur
ini_set('session.hash_function', "sha256"); // Utilisation du stric mode, n'accepte pas d'id fourni par l'utilisateur
ini_set('expose_php', 'off'); // Cache la version de PHP
date_default_timezone_set('Europe/Paris'); // Fuseau horaire à utiliser


// CONSTANTS

define( 'ABSPATH', dirname( __FILE__ ) . '/' );
define( 'INC', ABSPATH . 'inc/' );
define( 'TPL', ABSPATH . 'tpl/' );
define( 'VIEWS', ABSPATH . 'tpl/views/' );
define( 'ASSETS', ABSPATH . 'assets/' );
define( 'CONTROLLERS', ABSPATH . 'inc/controllers/' );

if ( empty($_GET['url'])  ) {
  header("Location: /en");
  die();
}

define( 'LANG', str_replace('/', '', $_GET['url']) );

// REQUIRES

require_once( INC . 'SiteConfig.php' );
require_once( INC . 'MethodPosts.php' );
require_once( INC . 'temp-functions.php' );
require_once( INC . 'Router.php' );
require_once( INC . 'Ajax.php' );
require_once( INC . 'MetaHandler.php' );
require_once( INC . 'ContactFormHandler.php' );
