<?php
/*
    =========================================
        Section
    =========================================
*/

class Section
{
  private $section;
  private $type;

  function __construct($raw_section)
  {
    $this->section = $raw_section;
    $this->type = $raw_section["type"];
  }

  public function run ()
  {
    $type = $this->type;

    if ( method_exists( $this, $type ) )
      return nl2br( $this->$type() );
    else
      return '';
  }


  // --------------------------         TEXTE          -------------------------

  private function text ()
  {
	$avec_titre = ( $this->section["content"]["title"] != "" && $this->section["content"]["title"] != " " ) ? true : false;
	$avec_contenu = ( $this->section["content"]["content"] != "" && $this->section["content"]["content"] != " " ) ? true : false;
	$r = '';
	
	if( $avec_titre || $avec_contenu ) {
		$r = '<div class="cstm-sec text-sec">';
		$r .= '<div class="text-wrapper ">';

		if ( $avec_titre ) $r .= "<h3>" . $this->section["content"]['title'] . "</h3>";

		if ( $avec_contenu ) $r .= "<p class=\"g-paragraph\">" . $this->section["content"]['content'] . "</p>";
		
		$r .= "</div>";
		$r .= "</div>";
	}

    return $r;
  }


  // ---------------------------         IMAGE          ------------------------

  private function image ()
  {
    $src = $this->section['content']['src'];
    $alt = $this->section['content']['alt'];

    if ( $src )
    {
      $src = UPLOADS_URL . 'img/' . $src;

      $r = "<div class=\"cstm-sec img-sec \">";
      $r .=   "<div class=\"img-wrapper\">";
      $r .=     '<img src="' . $src . '" alt="' . $alt . '">';
      $r .=   "</div>";
      $r .= "</div>";

      return $r;
    }
    else
    {
      return "Image manquante";
    }
  }


  // ---------------------------         TITRE          ------------------------

  private function title ()
  {
    $r = "<div class=\"cstm-sec title-sec " . $this->section["options"]['size'] . " " . $this->section["options"]['alignment'] . "\" data-color=\"" . $this->section["options"]['background_color'] . "\">";
    $r .= "<div class=\"title-wrapper\">";

    $r .= "<" . $this->section["options"]['size'] . " class=\"_a-single\">" . $this->section["content"]['title'] . "</" . $this->section["options"]['size'] . ">";
    $r .= "</div>";
    $r .= "</div>";

    return $r;
  }


  // ---------------------------         TITRE          ------------------------

  private function double ()
  {
    $r = '<div class="cstm-sec double-sec g-row-1">';

    $count = 1;

    foreach ($this->section['content']['sections'] as $section_value)
    {
      $r .= '<div class="double-sec-wrapper">';

      $section = new Section( $section_value );
      $r .= $section->run();

      $r .= '</div>';

      $count++;
    }

    $r .= '</div>';

    return $r;
  }
}
