<?php
/*
    =========================================
        Post
    =========================================
*/

require_once( INC . 'Section.php' );

class Post
{
  private $post;

  function __construct($post)
  {
    $this->post = $post;
  }

  // 01 - Titre

  public function title ()
  {
    return $this->post['title'];
  }


  // 02 - Date

  function date ()
  {
    return $this->post['date_mod_form'];
  }


  // 03 - Description

  function description ()
  {
    return $this->post['description'];
  }


  // 04 - Contenu

  function content ()
  {
    $rawContent = json_decode($this->post['content'], true);

    foreach ($rawContent as $raw_section)
    {
      $section = new Section( $raw_section );
      echo $section->run();
    }
  }


  // 05 - Miniature

  function thumb ( $size = "large" )
  {
    $post_thumb = MethodUploads::get_by_id( $this->post['thumb'] );
    if (!$post_thumb) $post_thumb = array('slug' => '');

    return $post_thumb;
  }


  // 06 - Catégories

  function categories ()
  {
    $r = [
      'category' => [],
    ];

    $sth = DataBase::prepare('
    SELECT term_id
    FROM relationships
    WHERE object_id = ?
    ');

    $sth->execute( [ $this->post['ID'] ] );

    $categories_id = $sth->fetchAll(PDO::FETCH_COLUMN);

    if ( count($categories_id ) > 0)
    {
      $test = implode(',',array_map([DataBase::$pdo,"quote"],$categories_id)) ;

      $sth = DataBase::prepare('
      SELECT *
      FROM categories
      WHERE ID IN ( ' . $test . ' )
      ');

      $sth->execute(  );

      $categories = $sth->fetchAll( );

      foreach ($categories as $key => $value)
      {
        if ( !isset( $r[ $value['type'] ] ) )
          $r[ $value['type'] ] = [];

        $r[ $value['type'] ][] = $value;
      }
    }

    return $r;
  }


  // 07 - Année

  // function post_year ()
  // {
  //   $r = $this->post['year'] === "" ? date('Y') : $this->post['year'];
  //   return $r;
  // }

}
