<?php
/*
    =========================================
        MethodUploads
    =========================================
*/

class MethodUploads
{
  public static function get_by_id ( $id, $size = "large" )
  {
    $media = false;

    if ( $id != "" )
    {
      $sth = DataBase::prepare('
        SELECT slug, type, poster, alt, display_name, caption
        FROM uploads
        WHERE ID = ?
      ');

      $sth->execute( [$id] );

      $row = $sth->fetch(PDO::FETCH_ASSOC);

      if ( $row )
      {
        $media = [];
        $media['slug'] = $row['slug'];
        $media['poster'] = $row['poster'];
        $media['alt'] = $row['alt'];
        $media['display_name'] = $row['display_name'];
        $media['caption'] = $row['caption'];

        if ( preg_match( '/image/', $row['type'] ) ) // Image
        {
          $media['type'] = 'image';
        }
        else // Video
        {
          $media['type'] = 'video';

          // Obtient le poster de la video
          $sth = DataBase::prepare('
          SELECT slug
          FROM uploads
          WHERE ID = ?
          ');

          $sth->execute( [ $row['poster'] ] );

          $poster_row = $sth->fetchAll();

          if ( count($poster_row) > 0 )
            $media['poster'] = UPLOADS_URL . 'img/large/' . $poster_row[0]['slug'];
          else
            $media['poster'] = '';
        }

      }
    }

    return $media;
  }
}
