<?php
/*
    =========================================
        ContactFormHandler
    =========================================
*/


class ContactFormHandler
{
  static private function died ($error)
  {
    // your error code can go here
    echo "We are very sorry, but there were error(s) found with the form you submitted. ";
    echo "These errors appear below.<br /><br />";
    echo $error."<br /><br />";
    echo "Please go back and fix these errors.<br /><br />";
    die();
  }

  static private function check_data_exist()
  {
    // validation expected data exists
    if(
      !isset($_POST['prenom']) ||
      !isset($_POST['nom']) ||
      !isset($_POST['email']) ||
      !isset($_POST['message']) ||
      !isset($_POST['objet'])
      )
    {
      self::died('Nous sommes désolé, une erreur est survenue. Veuillez réessayer.');
    }
  }

  static private function clean_string($string)
  {
    $bad = array("content-type","bcc:","to:","cc:","href");
    return str_replace($bad,"",$string);
  }

  static public function run ()
  {
    if(isset($_POST['email']))
    {
      self::check_data_exist();

      $first_name = strip_tags($_POST['prenom']); // required
      $last_name = strip_tags($_POST['nom']); // required
      $email_from = $_POST['email']; // required
      $comments = $_POST['message']; // required
      $email_subject = strip_tags ($_POST['objet']);

      $error_message = "";
      $email_exp = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';

      if(!preg_match($email_exp,$email_from))
      {
        $error_message .= 'L\'adresse n\'est pas valide.<br />';
      }

      $string_exp = "/^[A-Za-z .'-éèêâàîô]+$/";

      if(!preg_match($string_exp,$last_name))
      {
        $error_message .= 'Le nom n\'est pas valide.<br />';
      }

      if(strlen($comments) < 2)
      {
        $error_message .= 'Le message n\'est pas valide.<br />';
      }

      if(strlen($error_message) > 0)
      {
        self::died($error_message);
      }

      $email_to_0 = "christophe@lagencepigment.com";
      $email_to_1 = "thomas@lagencepigment.com";


      $email_message = "Prénom: ".self::clean_string($first_name)."\n";
      $email_message .= "Nom: ".self::clean_string($last_name)."\n";
      $email_message .= "Email: ".self::clean_string($email_from)."\n\n";
      $email_message .= self::clean_string($comments)."\n";

      // create email headers
      $headers = 'From: '.$email_from."\r\n".
                 'Reply-To: '.$email_from."\r\n" .
                 'X-Mailer: PHP/' . phpversion();

      $is_send = @mail($email_to_0, utf8_decode($email_subject), utf8_decode($email_message), $headers);
      $is_send = @mail($email_to_1, utf8_decode($email_subject), utf8_decode($email_message), $headers);

      // Return :
      if ($is_send)
      {
        header("Location: /" . LANG . "?success=true");
        die();
      }
      else
      {
        header("Location: /" . LANG . "?success=false");
        die();
      }
    }
  }
}
